/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor;

import com.quantumdata.std.QDUtil;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDStdUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class FmtUI {
    public static final int GRAY_LED = 0;
    public static final int YELLOW_LED = 1;
    public static final int RED_LED = 2;
    public static final int GREEN_LED = 3;
    private static Font m_unitFont = new Font("Serif", 0, 10);
    private static Icon[] m_icons = null;

    public static JTextField createLabel(String string) {
        JTextField jTextField = new JTextField(" " + string);
        jTextField.setEditable(false);
        jTextField.setForeground(QDStdUI.getActionForeground());
        jTextField.setOpaque(false);
        jTextField.setBorder(BorderFactory.createLineBorder(QDStdUI.getBackground(), 3));
        jTextField.setFocusable(false);
        return jTextField;
    }

    public static QDLabel createUnitLabel(String string) {
        QDLabel qDLabel = new QDLabel(string);
        qDLabel.setHorizontalAlignment(2);
        qDLabel.setFont(m_unitFont);
        return qDLabel;
    }

    public static Border createLoweredBorder(int n) {
        Border border = BorderFactory.createEmptyBorder(n, n, n, n);
        border = BorderFactory.createCompoundBorder(QDStdUI.getLoweredBorder(), border);
        return border;
    }

    public static Border createLoweredBorder(int n, int n2) {
        Border border = BorderFactory.createEmptyBorder(n2, n, n2, n);
        border = BorderFactory.createCompoundBorder(QDStdUI.getLoweredBorder(), border);
        return border;
    }

    public static void addPair(int n, int n2, QDPanel qDPanel, JComponent jComponent, JComponent jComponent2) {
        GridBagLayout gridBagLayout = (GridBagLayout)qDPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        qDPanel.add((Component)jComponent);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = n + 1;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        qDPanel.add((Component)jComponent2);
    }

    public static void addTrio(int n, int n2, QDPanel qDPanel, JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        GridBagLayout gridBagLayout = (GridBagLayout)qDPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        qDPanel.add((Component)jComponent);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = n + 1;
        if (jComponent3 == null) {
            gridBagConstraints.gridwidth = 2;
        }
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        qDPanel.add((Component)jComponent2);
        if (jComponent3 != null) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = n + 2;
            gridBagLayout.setConstraints(jComponent3, gridBagConstraints);
            qDPanel.add((Component)jComponent3);
        }
    }

    public static Icon getIcon(int n) {
        if (m_icons == null) {
            m_icons = new Icon[4];
            FmtUI.m_icons[0] = QDUtil.loadIcon((String)"ledGray.png");
            FmtUI.m_icons[1] = QDUtil.loadIcon((String)"ledYellow.png");
            FmtUI.m_icons[2] = QDUtil.loadIcon((String)"ledRed.png");
            FmtUI.m_icons[3] = QDUtil.loadIcon((String)"ledGreen.png");
        }
        return m_icons[n];
    }
}

